﻿#pragma

class StgMediumScope
{
public:

  StgMediumScope(STGMEDIUM * pStg) : m_pStg(pStg)
  {
  }

  ~StgMediumScope()
  {
    ReleaseStgMedium(m_pStg);
  }

private:

  STGMEDIUM * m_pStg;
};

class GlobalLockScope
{
public:

  GlobalLockScope(HGLOBAL hGlobal) : m_hGlobal(hGlobal), m_pVoid(GlobalLock(m_hGlobal))
  {
  }

  ~GlobalLockScope()
  {
    GlobalUnlock(m_hGlobal);
  }

  LPVOID Get() const { return m_pVoid; }

private:

  HGLOBAL m_hGlobal;
  LPVOID m_pVoid;
};

class IconScope
{
public:

  IconScope(HICON hIcon) : m_hIcon(hIcon)
  {
  }

  ~IconScope()
  {
    if (m_hIcon != 0)
      DestroyIcon(m_hIcon);
  }

  operator HICON () { return m_hIcon; }

private:

  HICON m_hIcon;
};

class BitmapScope
{
public:

  BitmapScope(HBITMAP hBitmap) : m_hBitmap(hBitmap)
  {
  }

  ~BitmapScope()
  {
    if (m_hBitmap != 0)
      DeleteObject(m_hBitmap);
  }

  operator HBITMAP () { return m_hBitmap; }

private:

  HBITMAP m_hBitmap;
};

class DcOwner
{
public:

  DcOwner(HDC hdc) : m_hdc(hdc)
  {
  }

  ~DcOwner()
  {
    if (m_hdc != 0)
      DeleteDC(m_hdc);
  }

  operator HDC () { return m_hdc; }

private:

  HDC m_hdc;
};

class DcHolder
{
public:

  DcHolder(HWND hwnd, HDC hdc) : m_hwnd(hwnd), m_hdc(hdc)
  {
  }

  ~DcHolder()
  {
    if (m_hwnd != 0 && m_hdc != 0)
      ReleaseDC(m_hwnd, m_hdc);
  }

  operator HDC () { return m_hdc; }

private:

  HWND m_hwnd;
  HDC m_hdc;
};

